/*
 * $Id: pgpDSAKey.h,v 1.5 2001/01/25 22:11:29 jeffc Exp $
 */

#ifndef Included_pgpDSAKey_h
#define Included_pgpDSAKey_h

#include "pgpPubTypes.h"	/* For PGPByte */
#include "pgpOpaqueStructs.h"
#include <stddef.h>	/* For size_t */

PGP_BEGIN_C_DECLARATIONS

/* Bits for uniqueness of p, q */
#define DSADUMMYBITS	64


PGPPubKey *dsaPubFromBuf( PGPContextRef	context,
				PGPByte const *buf, PGPSize len, PGPError *error);
				
PGPSecKey *dsaSecFromBuf( PGPContextRef	context,
				PGPByte const *buf, PGPSize len, PGPError *error);
				
int			dsaPubKeyPrefixSize(PGPByte const *buf, PGPSize size);

PGPSecKey *	dsaSecGenerate(PGPContextRef context,
				unsigned bits, PGPBoolean fastgen,
				PGPRandomContext const *rc,
				int progress(void *arg, int c), void *arg, PGPError *error);

PGPError	pgpTestDSA(void);

PGP_END_C_DECLARATIONS

#endif /* Included_pgpDSAKey_h */
